/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.MCF;
import com.ibm.hwmca.base.updates.McfComponentListener;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;

public final class McfComponentListenerManager
implements McfComponentListener,
UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCFCLMT";
    private static final String TRACE_MASKF = "XMCFCLMF";
    private static final String TRACE_MASKD = "XMCFCLMD";
    private static final String TRACE_CLASS = "McfComponentListenerManager";
    private static final String TRACE_IN = "-> ";
    private static final String TRACE_OUT = "<- ";
    private static final String TRACE_INOUT = "<> ";
    private static final String TRACE_OTHER = "   ";
    private static final int DISCOVERY = 1;
    private static final int PATCH_START = 2;
    private static final int PATCH_END = 3;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "McfCmpLstMgr");
    private static McfComponentListenerManager theMcfComponentListenerManager = null;
    private ArrayList listeners = new ArrayList();
    private Object listenersLock = new Object();

    public static synchronized McfComponentListenerManager getMcfComponentListenerManager() {
        String TRACE_METHOD = ".getMcfComponentListenerManager()";
        Trace.trace(TRACE_MASKT, "-> McfComponentListenerManager" + TRACE_METHOD);
        if (theMcfComponentListenerManager == null) {
            theMcfComponentListenerManager = new McfComponentListenerManager();
        }
        Trace.trace(TRACE_MASKT, "<- McfComponentListenerManager" + TRACE_METHOD);
        return theMcfComponentListenerManager;
    }

    private McfComponentListenerManager() {
        String TRACE_METHOD = ".ctor()";
        Trace.trace(TRACE_MASKT, "<> McfComponentListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(McfComponentListener listener) {
        String TRACE_METHOD = ".addListener()";
        Trace.trace(TRACE_MASKT, "-> McfComponentListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<- McfComponentListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(McfComponentListener listener) {
        String TRACE_METHOD = ".removeListener()";
        Trace.trace(TRACE_MASKT, "-> McfComponentListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
        Trace.trace(TRACE_MASKT, "<- McfComponentListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(int type, String component, MCF mcf, boolean success) {
        ArrayList listeners;
        String TRACE_METHOD = ".sendEvent()";
        Trace.trace(TRACE_MASKT, "-> McfComponentListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            listeners = (ArrayList)this.listeners.clone();
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            McfComponentListener l = (McfComponentListener)iterator.next();
            switch (type) {
                case 1: {
                    l.componentDiscovered(component, mcf);
                    break;
                }
                case 2: {
                    l.patchSessionStarting();
                    break;
                }
                case 3: {
                    l.patchSessionCompleting(success);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- McfComponentListenerManager" + TRACE_METHOD);
    }

    public void componentDiscovered(String component, MCF mcf) {
        String TRACE_METHOD = ".componentDiscovered()";
        Trace.trace(TRACE_MASKT, "-> McfComponentListenerManager" + TRACE_METHOD);
        this.sendEvent(1, component, mcf, true);
        Trace.trace(TRACE_MASKT, "<- McfComponentListenerManager" + TRACE_METHOD);
    }

    public void patchSessionStarting() {
        String TRACE_METHOD = ".patchSessionStarting()";
        Trace.trace(TRACE_MASKT, "-> McfComponentListenerManager" + TRACE_METHOD);
        this.sendEvent(2, null, null, true);
        Trace.trace(TRACE_MASKT, "<- McfComponentListenerManager" + TRACE_METHOD);
    }

    public void patchSessionCompleting(boolean success) {
        String TRACE_METHOD = ".patchSessionCompleting()";
        Trace.trace(TRACE_MASKT, "-> McfComponentListenerManager" + TRACE_METHOD);
        this.sendEvent(3, null, null, success);
        Trace.trace(TRACE_MASKT, "<- McfComponentListenerManager" + TRACE_METHOD);
    }
}

